/* eslint-disable camelcase */

import {
    IFlightDetailedParams,
    IFlightInfo,
} from 'server/api/AviaFlightStorageApi/types/IFlight';
import {IFlight} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

const getTimeKeyPart = (day: string, time: string): string =>
    [day.slice(2).split('-').join(''), time.slice(0, 5).replace(':', '')].join(
        'T',
    );

export function convertFlightToReference(
    flightsInfo: IFlightInfo[],
    params: IFlightDetailedParams,
    idx: number,
): IFlight | null {
    const {iata, number} = params;
    const flightInfo = flightsInfo[idx];

    if (flightInfo) {
        const {flight} = flightInfo;
        const {arrival_day, arrival_time, departure_day, departure_time} =
            flight;

        const key = [
            getTimeKeyPart(departure_day, departure_time),
            `${iata}${number}`,
            getTimeKeyPart(arrival_day, arrival_time),
        ].join('');

        return {
            arrival: {
                local: `${arrival_day}T${arrival_time}`,
                offset: flightInfo.airport_to.timeZoneUtcOffset,
            },
            departure: {
                local: `${departure_day}T${departure_time}`,
                offset: flightInfo.airport_from.timeZoneUtcOffset,
            },
            company: flight.airline_id,
            from: flight.airport_from_id,
            to: flight.airport_to_id,
            key,
            number: flight.number,
            tModel: '',
            operating: null,
        };
    }

    return null;
}
