/**
 * @see https://st.yandex-team.ru/RASPTICKETS-15284
 * Позволяет декодировать forward и backward.
 * Если декодировать не получилось, то заменяет их на пустую строку.
 * Нужно для случаев некорректного экранирования пробела и двоеточия в этих параметрах
 */
export function decodeParams(params: {forward: string; backward?: string}): {
    forward: string;
    backward?: string;
} {
    const decodedParams = {
        ...params,
    };

    if (decodedParams.forward) {
        try {
            decodedParams.forward = decodeURIComponent(decodedParams.forward);
        } catch {
            decodedParams.forward = '';
        }
    }

    if (decodedParams.backward) {
        try {
            decodedParams.backward = decodeURIComponent(decodedParams.backward);
        } catch {
            decodedParams.backward = '';
        }
    }

    return decodedParams;
}
