import {IFlightDetailedParams} from 'server/api/AviaFlightStorageApi/types/IFlight';

export function parseFlights(flights: string = ''): IFlightDetailedParams[] {
    return flights
        .split(',')
        .filter(Boolean)
        .map((flightString: string) => {
            const [flight, date] = flightString.split('.');
            const [iata, number] = flight.split(' ');
            return {
                iata,
                number,
                flightDay: date.split('T')[0],
            };
        });
}
