import {IAviaGetFlightsToData} from 'server/services/AviaFlightsToService/types/IAviaGetFlightsToData';

import {IDependencies} from 'server/getContainerConfig';
import {AviaFlightsToApi} from 'server/api/AviaFlightsToApi/AviaFlightsToApi';

export interface IAviaFlightsToService {
    getFlightsToData: IAviaGetFlightsToData;
}

export class AviaFlightsToService {
    private aviaFlightToApi: AviaFlightsToApi;

    constructor({aviaFlightToApi}: IDependencies) {
        this.aviaFlightToApi = aviaFlightToApi;
    }

    getFlightsToData: IAviaGetFlightsToData = params => {
        return this.aviaFlightToApi.getFlightsToData(params);
    };
}
