/* eslint-disable camelcase */
import {TGeoId} from 'types/TGeoId';
import {TRaspId} from 'types/TRaspId';

import {ICoordinate} from 'server/utilities/earthGeometry';

export interface IAviaCountryData {
    title: string;
    code: string;
    id: number;
    point_key: string;
    geo_id: string;
}

// Общие свойства для информации о станции и населенном пункте
export interface IAviaPointCommonData extends ICoordinate {
    id: TRaspId;
    title: string; // 'Симферополь'
    urlTitle: string; // 'Simferopol'
    phraseIn: string | null; // 'Симферополе'
    phraseFrom: string | null; // 'Симферополя'
    phraseTo: string | null; // 'Симферополь'
}

// Информация о станции
export interface IAviaPointStationData extends IAviaPointCommonData {
    iataCode: string | null; // 'SIP'
    popularTitle: string | null; // 'Симферополь'
    sirenaCode: string | null; // 'СИП'
    transportType: number; // 2
}

// Информация о населенном пункте
export interface IAviaPointSettlementData extends IAviaPointCommonData {
    geoId: TGeoId;
    iata: string | null; // 'SVX'
    sirena: string | null; // 'СИП'
}

// Информация о регионе
export interface IAviaPointRegionData {
    id: number; // 11162 // Идентификатор из БД расписаний
    geoId: number; // 11162 // Идентификатор из геобазы
    title: string; // 'Москва и Московская область'
}

// Информация о стране
export interface IAviaPointCountryData {
    id: number; // 225 // Идентификатор из БД расписаний
    geoId: number; // 225 // Идентификатор из геобазы
    title: string; // 'Россия'
    code: string; // 'RU'
}

export interface IAviaDataByPointKey {
    station: IAviaPointStationData | null;
    settlement: IAviaPointSettlementData | null;
    region: IAviaPointRegionData | null;
    country: IAviaPointCountryData | null;
}
