import {TRaspId} from 'types/TRaspId';
import {
    IAviaCountryData,
    IAviaDataByPointKey,
} from 'server/services/AviaGeoService/types/IAviaDataByPointKey';
import {TGeoId} from 'types/TGeoId';
import {TSettlementKey, TStationKey} from 'types/PointKey';
import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

export interface IAviaGeoService {
    getCountry: IAviaGeoServiceGetCountry;
    getCountries: IAviaGeoServiceGetCountries;
    getDataByGeoId: IAviaGeoServiceGetDataByGeoId;
    getDataByPointKey: IAviaGeoServiceGetDataByPointKey;
    getDirectionsData: IAviaGeoServiceGetDirectionsData;
}

export interface IAviaGeoServiceGetCountry {
    (id: TRaspId): Promise<IAviaCountryData | null>;
}

export interface IAviaGeoServiceGetCountries {
    (): Promise<Record<TRaspId, IAviaCountryData> | null>;
}

export interface IAviaGeoServiceGetDataByGeoId {
    (geoId: TGeoId): Promise<IAviaDataByPointKey | null>;
}

export interface IAviaGeoServiceGetDataByPointKey {
    (key: TSettlementKey | TStationKey): Promise<IAviaDataByPointKey | null>;
}

export interface IAviaGeoServiceGetDirectionsData {
    (params: IAviaParams): Promise<{
        from: IAviaDataByPointKey;
        to: IAviaDataByPointKey;
    } | null>;
}
