/* eslint-disable camelcase */
import IPrice from 'utilities/currency/PriceInterface';

interface ICountry {
    id: number;
    title: string;
}

export interface IDirectionCity {
    key: string;
    title: string;
    country: ICountry;
    geoId: number;
    latitude: number;
    longitude: number;
    iataCode?: string;
    id: number;
    urlTitle: string;
}

export interface INearDistances {
    minDistance: number;
    maxDistance: number;
    defaultDistance: number;
}

export interface INearDirection {
    price: IPrice;
    fromCity: {
        key: string;
        title: string;
        country: ICountry;
    };
    toCity: IDirectionCity;
}

export interface INearItem {
    title: string;
    fullTitle: string;
    geoid: number;
    price: IPrice;
    distance: number;
    point: [number, number];
    iataCode?: string;
    id: number;
    urlTitle: string;
    country: string;
    key: string;
}

export interface IToPoint {
    name: string;
    phraseFrom: string;
    point: [number, number];
}

export interface INearAnswer {
    toPoint: IToPoint;
    nearPoints: INearItem[];
}
