import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_AVIA_CLASS,
    DEFAULT_INFANTS_COUNT,
    DEFAULT_CHILDREN_COUNT,
} from 'constants/avia';

import {IAviaTDAnswer} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';
import {IAviaGetOrderFromTicketDaemonParams} from 'server/services/AviaOrderService/types/IAviaGetOrderParams';
import {IAviaGoodPriceParams} from 'server/services/AviaOrderService/types/IAviaGoodPriceParams';
import {IAviaGoodPrice} from 'types/avia/IAviaGoodPrice';
import {IAviaGetOrderService} from 'server/services/AviaOrderService/types/IAviaGetOrderService';
import {ICookies} from '@yandex-data-ui/core/lib/types';

import {IAviaBackendApiClient} from 'server/utilities/AviaBackendApiClient/IAviaBackendApiClient';
import {getAviaTestContext} from 'server/utilities/avia/getAviaTestContext';

import {IDependencies} from 'server/getContainerConfig';
import {AviaTicketDaemonApi} from 'server/api/AviaTicketDaemonApi/AviaTicketDaemonApi';
import {AviaFlightStorageService} from 'server/services/AviaFlightStorageService';

export interface IAviaOrderService {
    getOrder: IAviaGetOrderService;
}

export class AviaOrderService implements IAviaOrderService {
    private flightStorageService: AviaFlightStorageService;
    private aviaTicketDaemonApi: AviaTicketDaemonApi;
    private aviaGatewayBackendApiClient: IAviaBackendApiClient;
    private readonly cookies: ICookies;

    constructor({
        aviaFlightStorageService,
        aviaTicketDaemonApi,
        aviaGatewayBackendApiClient,
        cookies,
    }: IDependencies) {
        this.flightStorageService = aviaFlightStorageService;
        this.aviaTicketDaemonApi = aviaTicketDaemonApi;
        this.aviaGatewayBackendApiClient = aviaGatewayBackendApiClient;
        this.cookies = cookies;
    }

    async getGoodPrice(
        params: IAviaGoodPriceParams,
    ): Promise<IAviaGoodPrice | null> {
        return this.aviaGatewayBackendApiClient.request<IAviaGoodPrice>({
            name: 'goodPrice',
            params: {
                fromPointKey: params.fromPointKey,
                toPointKey: params.toPointKey,
                departure: params.departure,
                routes: params.routes,
                adultSeats: params.adultSeats,
                childrenSeats: params.childrenSeats,
                infantSeats: params.infantSeats,
            },
        });
    }

    getOrder: IAviaGetOrderService = async params => {
        let dataFromTD = null;

        if (params.qid) {
            try {
                dataFromTD = await this.getOrderDataFromTicketDaemon(
                    params as IAviaGetOrderFromTicketDaemonParams,
                );
            } catch (e) {}
        }

        return dataFromTD?.variants.fares.length
            ? dataFromTD
            : await this.flightStorageService.getOrder({
                  forward: params.forward,
                  backward: params.backward,
              });
    };

    getOrderDataFromTicketDaemon(
        params: IAviaGetOrderFromTicketDaemonParams,
    ): Promise<IAviaTDAnswer> {
        return this.aviaTicketDaemonApi.getOrder({
            qid: params.qid,
            adults: params.adult_seats || `${DEFAULT_ADULTS_COUNT}`,
            children: params.children_seats || `${DEFAULT_CHILDREN_COUNT}`,
            infants: params.infant_seats || `${DEFAULT_INFANTS_COUNT}`,
            klass: params.klass || DEFAULT_AVIA_CLASS,
            forward: params.forward,
            backward: params.backward,
            point_from: params.fromId,
            point_to: params.toId,
            date_backward: params.return_date || undefined,
            date_forward: params.when,
            partners: params.partners,
            test_context: getAviaTestContext({
                cookies: this.cookies,
            }),
        });
    }
}
