import {IPassengerExperience} from 'projects/avia/types/IPassengerExperience';

export interface IAviaGetPassengerExperienceParams {
    planeNumber: string;
    when: string;
    lang?: string;
    klass: 'economy' | 'business';
}

type TPresumedField<T> = T | null;

export interface IPresumedFields {
    ife: TPresumedField<boolean>;
    power: TPresumedField<boolean>;
    wifi: TPresumedField<boolean>;
    seatPitch: TPresumedField<number>;
    seatsTotal: TPresumedField<number>;
    planeModel: TPresumedField<string>;
    seatsInRow: TPresumedField<string>;
    hasPropeller: TPresumedField<boolean>;
    [key: string]: any;
}

export type TAviaGetPassengerExperience = (
    params: IAviaGetPassengerExperienceParams,
) => Promise<IPassengerExperience | null>;
