import moment from 'moment';

import {TCalendarPrices} from 'types/common/calendarPrice/ICalendarPrice';
import {IAviaMinPriceSearchResult} from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiResponse';

import {median} from 'utilities/math/median';

import getTzOffset from './getTzOffset';

const MEDIAN_THRESHOLD_COEFFICIENT = 0.8;

export default function convertCalendarPrices(
    prices: IAviaMinPriceSearchResult[],
    useBackward: boolean,
): TCalendarPrices {
    const tzOffset = getTzOffset();
    const today = moment().startOf('day').utcOffset(tzOffset);
    const anchorValue =
        MEDIAN_THRESHOLD_COEFFICIENT *
        median(
            prices
                .map(item => item.minPrice?.value)
                .filter((item): item is number => typeof item === 'number'),
        );

    return prices
        .map(item => ({
            date: useBackward ? item.backwardDate : item.forwardDate,
            price: item.minPrice
                ? {
                      ...item.minPrice,
                      isLow: item.minPrice.value < anchorValue,
                      roughly: !isRecentPrice(item.updatedAt, today, tzOffset),
                  }
                : null,
        }))
        .reduce((map, item) => {
            if (item.price) {
                map[item.date] = item.price;
            }

            return map;
        }, {} as TCalendarPrices);
}

function isRecentPrice(
    updatedAt: string,
    today: moment.Moment,
    tzOffset: number,
): boolean {
    return moment(updatedAt).utcOffset(tzOffset).isSame(today, 'day');
}
