import moment from 'moment';

import {IAviaPriceIndexSearchDTO} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexSearchDTO';
import {TAviaPriceIndexDynamicsData} from 'server/api/AviaPriceIndexApi/types/TAviaPriceIndexDynamicsData';

import getTzOffset from './getTzOffset';

export default function convertDynamicsPrices(
    dynamicsDTO: IAviaPriceIndexSearchDTO,
): TAviaPriceIndexDynamicsData {
    const tzOffset = getTzOffset();
    const now = moment().startOf('day').utcOffset(tzOffset);

    return Object.keys(dynamicsDTO.data).reduce((data, date) => {
        const {value, currency, updatedAt} = dynamicsDTO.data[date];

        data[date] = {
            value,
            currency,
            roughly: !moment(updatedAt).utcOffset(tzOffset).isSame(now, 'day'),
        };

        return data;
    }, {} as TAviaPriceIndexDynamicsData);
}
