import {Optional} from 'utility-types';

import {IAviaPriceIndexSearchParams} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexSearchParams';
import IAviaMinPriceBatchSearchApiParams from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiParams';

import getCalendarPricesByArrival from './utilities/getCalendarPricesByArrival';
import getCalendarPricesByDeparture from './utilities/getCalendarPricesByDeparture';

const MONTH = 30;
const MAX_DAYS = 4 * MONTH;

export default function getCalendarPriceMinRequests(
    params: Optional<IAviaPriceIndexSearchParams, 'forwardDate'>,
): IAviaMinPriceBatchSearchApiParams['minRequests'] {
    return !params.forwardDate && params.backwardDate
        ? getCalendarPricesByArrival(params, MAX_DAYS)
        : getCalendarPricesByDeparture(params, MAX_DAYS);
}
