import moment from 'moment';
import {Optional} from 'utility-types';

import {IAviaPriceIndexSearchParams} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexSearchParams';
import IAviaMinPriceBatchSearchApiParams from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiParams';

import {getDaysPeriod} from 'utilities/dateUtils/getPeriod';
import {ROBOT} from 'utilities/dateUtils/formats';

/** Если есть только дата прибытия - декрементируем forwardDate с даты прибытия по текущую дату */
export default function getCalendarPricesByArrival(
    params: Optional<IAviaPriceIndexSearchParams, 'forwardDate'>,
    maxDays: number,
): IAviaMinPriceBatchSearchApiParams['minRequests'] {
    const now = moment();
    const startByBackwardDate = moment(params.backwardDate).subtract(
        maxDays,
        'day',
    );
    const days = getDaysPeriod({
        from: startByBackwardDate.isBefore(now)
            ? now.format(ROBOT)
            : startByBackwardDate.format(ROBOT),
        to: moment(params.backwardDate).format(ROBOT),
    });

    return days.map(day => ({
        ...params,
        forwardDate: day,
        backwardDate: params.backwardDate ?? undefined,
    }));
}
