import moment from 'moment';
import {Optional} from 'utility-types';

import {IAviaPriceIndexSearchParams} from 'server/api/AviaPriceIndexApi/types/IAviaPriceIndexSearchParams';
import IAviaMinPriceBatchSearchApiParams from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiParams';

import {getDaysPeriod} from 'utilities/dateUtils/getPeriod';
import {ROBOT} from 'utilities/dateUtils/formats';

/**
 * Если нет даты отправления - инкрементируем forwardDate с текущей даты
 * Если дата отправления есть - инкрементируем backwardDate с даты отправления
 */
export default function getCalendarPricesByDeparture(
    params: Optional<IAviaPriceIndexSearchParams, 'forwardDate'>,
    maxDays: number,
): IAviaMinPriceBatchSearchApiParams['minRequests'] {
    const days = getDaysPeriod({
        from: moment(params.forwardDate).format(ROBOT),
        to: moment(params.forwardDate).add(maxDays, 'day').format(ROBOT),
    });

    return days.map(day => ({
        ...params,
        forwardDate: params.forwardDate || day,
        backwardDate: params.forwardDate ? day : undefined,
    }));
}
