import {IAviaRouteResponse} from 'types/avia/landing/route/IAviaRoute';
import {IAviaRouteDataRequestParams} from 'server/api/AviaApi/types/IAviaRouteData';

import {IDependencies} from 'server/getContainerConfig';
import {AviaRouteApi} from 'server/api/AviaRouteApi/AviaRouteApi';

export type TAviaGetRouteData = (
    params: IAviaRouteDataRequestParams,
) => Promise<IAviaRouteResponse>;

export interface IAviaRouteService {
    getRouteData: TAviaGetRouteData;
}

export class AviaRouteService implements IAviaRouteService {
    private aviaRouteApi: AviaRouteApi;

    constructor({aviaRouteApi}: IDependencies) {
        this.aviaRouteApi = aviaRouteApi;
    }

    async getRouteData(
        params: IAviaRouteDataRequestParams,
    ): Promise<IAviaRouteResponse> {
        return this.aviaRouteApi.getRouteData(params);
    }
}
