import {EAviaClassType} from 'types/avia/EAviaClassType';

/** Параметры авиа */
export interface IAviaParams
    extends IBaseSearchParams,
        ISeatParams,
        Partial<IFlightParams>,
        Partial<IBaggageParams>,
        Partial<IRefundParams>,
        Partial<IYtpRefererParams> {
    /** Место отправления - название */
    fromName?: string;
    /** Место прибытия - название */
    toName?: string;
}

/** Boolean переменная в query параметрах (1 - true, иначе false) */
export type TSearchFormBoolean = '1' | undefined;

/** Признак перелета только туда или туда и обратно */
export enum EOneWay {
    /** только туда */
    ONE_WAY = '1',
    /** туда и обратно */
    ROUND_TRIP = '2',
}

export interface IBaseSearchParams {
    /** Место отправления (TSettlementKey | TStationKey) */
    fromId: string;
    /** Место прибытия (TSettlementKey | TStationKey) */
    toId: string;
    /** Класс обслуживания */
    klass: EAviaClassType;
    /** Дата полета */
    when: string;
    /** Дата обратного билета */
    return_date: string;
    /** Признак перелета только туда или туда и обратно */
    oneway: EOneWay;
}

export interface IYtpRefererParams {
    ytp_referer: string;
}

/** Рейсы */
export interface IFlightParams {
    /** Рейсы туда */
    forward: string;
    /** Рейсы отбратно */
    backward?: string;
}

/** Посадочные места */
export interface ISeatParams {
    /** Количество взрослых */
    adult_seats: string;
    /** Количество детей */
    children_seats: string;
    /** Количество младенцев */
    infant_seats: string;
}

/** Багаж */
export interface IBaggageParams {
    /** Наличие багажа */
    baggage?: TSearchFormBoolean;
}

/** Возврат */
export interface IRefundParams {
    /** Бесплатный возврата */
    free_refund?: TSearchFormBoolean;
    /** Платный возврат */
    charge_refund?: TSearchFormBoolean;
}
