import {IAviaGetFlightPageService} from 'server/services/AviaService/types/IAviaGetFlightPageService';
import {IAviaGetSuggestsService} from 'server/services/AviaService/types/IAviaGetSuggestsService';
import {IAviaGetGeoLookupService} from 'server/services/AviaService/types/IAviaGetGeoLookupService';
import {IAviaGetSearchToCountryPageService} from 'server/services/AviaService/types/IAviaGetSearchToCountryPageService';
import {IAviaGetSearchToAnywherePageService} from 'server/services/AviaService/types/IAviaGetSearchToAnywherePageService';
import {IAviaGetExtendedCountryRestrictionsService} from 'server/services/AviaService/types/IAviaGetCountryRestrictionsService';

import {ILogger} from 'server/utilities/Logger';
import prepareSuggestsResponse from 'server/services/AviaService/utilities/prepareSuggestsResponse';

import {IDependencies} from 'server/getContainerConfig';
import {AviaGatewayApi} from 'server/api/AviaGatewayApi/AviaGatewayApi';
import {AviaSuggestsApi} from 'server/api/AviaSuggestsApi/AviaSuggestsApi';
import {AviaBackendApi} from 'server/api/AviaBackendApi/AviaBackendApi';
import {AviaCountryRestrictionsApi} from 'server/api/AviaCountryRestrictionsApi/AviaCountryRestrictionsApi';

export interface IAviaService {
    getGeoLookup: IAviaGetGeoLookupService;
    getFlightPage: IAviaGetFlightPageService;
    getSuggests: IAviaGetSuggestsService;
    getSearchToCountryPage: IAviaGetSearchToCountryPageService;
    getSearchToAnywherePage: IAviaGetSearchToAnywherePageService;
    getExtendedCountryRestrictions: IAviaGetExtendedCountryRestrictionsService;
}

export class AviaService implements IAviaService {
    private aviaGatewayApi: AviaGatewayApi;
    private aviaSuggestsApi: AviaSuggestsApi;
    private aviaBackendApi: AviaBackendApi;
    private aviaCountryRestrictionsApi: AviaCountryRestrictionsApi;
    private logger: ILogger;

    constructor({
        aviaGatewayApi,
        aviaSuggestsApi,
        aviaBackendApi,
        aviaCountryRestrictionsApi,
        logger,
    }: IDependencies) {
        this.aviaGatewayApi = aviaGatewayApi;
        this.aviaSuggestsApi = aviaSuggestsApi;
        this.aviaBackendApi = aviaBackendApi;
        this.aviaCountryRestrictionsApi = aviaCountryRestrictionsApi;
        this.logger = logger;
    }

    getGeoLookup: IAviaGetGeoLookupService = async params => {
        const response = await this.aviaBackendApi.geoLookup(params);

        if (!response) {
            this.logger.logError('geoLookup', new Error('Empty answer'));

            return null;
        }

        return response;
    };

    getSuggests: IAviaGetSuggestsService = async params => {
        const apiResponse = await this.aviaSuggestsApi.getSuggests(params);

        return prepareSuggestsResponse(params, apiResponse);
    };

    getFlightPage: IAviaGetFlightPageService = async params =>
        this.aviaGatewayApi.getFlightPage(params);

    getExtendedCountryRestrictions: IAviaGetExtendedCountryRestrictionsService =
        async params =>
            this.aviaCountryRestrictionsApi.getExtendedCountryRestrictions(
                params,
            );

    getSearchToCountryPage: IAviaGetSearchToCountryPageService = async params =>
        this.aviaGatewayApi.getSearchToCountryPage(params);

    getSearchToAnywherePage: IAviaGetSearchToAnywherePageService =
        async params => this.aviaGatewayApi.getSearchToAnywherePage(params);
}
