import {IDependencies} from 'server/getContainerConfig';
import {AviaSettlementSlugApi} from 'server/api/AviaSettlementSlugApi/AviaSettlementSlugApi';
import {
    IAviaSettlementSlugRequestParams,
    IAviaSettlementSlugResponse,
} from 'server/api/AviaSettlementSlugApi/AviaSettlementSlugTypes';

export class AviaSettlementSlugService {
    private aviaSettlementSlugApi: AviaSettlementSlugApi;

    constructor({aviaSettlementSlugApi}: IDependencies) {
        this.aviaSettlementSlugApi = aviaSettlementSlugApi;
    }

    async getSettlementSlugByGeoId(
        params: IAviaSettlementSlugRequestParams,
    ): Promise<IAviaSettlementSlugResponse> {
        return this.aviaSettlementSlugApi.getSettlementSlugByGeoId(params);
    }
}
