import {
    ISubscribeParams,
    ISubscriptionsParams,
    ISubscribeByEmailParams,
    IConfirmSubscriptionsParams,
    IUnsubscribeParams,
    ISubscriptionsAnswer,
    IConfirmSubscriptionAnswer,
} from 'server/api/AviaApi/types/subscriptions';

import {decodeQidOrDefault} from 'projects/avia/lib/qid';

import {IDependencies} from 'server/getContainerConfig';
import {AviaApi} from 'server/api/AviaApi';

export class AviaSubscriptionService {
    private aviaApi: AviaApi;

    constructor({aviaApi}: IDependencies) {
        this.aviaApi = aviaApi;
    }

    subscriptions(params: ISubscriptionsParams): Promise<ISubscriptionsAnswer> {
        return this.aviaApi.subscriptions({
            qid: params.qid,
        });
    }

    subscribe(params: ISubscribeParams): Promise<void> {
        return this.aviaApi.subscribe({
            qid: params.qid,
            minPrice: params.minPrice,
        });
    }

    subscribeByEmail(params: ISubscribeByEmailParams): Promise<{
        id: string;
        needsConfirmation: boolean;
    }> {
        return this.aviaApi
            .subscribeByEmail({
                qid: params.qid,
                email: params.email,
                minPrice: params.minPrice,
            })
            .then(data => ({
                id: data.id,
                needsConfirmation: data.required_double_opt_in,
            }));
    }

    unsubscribe(params: IUnsubscribeParams): Promise<void> {
        return this.aviaApi.unsubscribe({
            id: params.id,
        });
    }

    unsubscribeByDirection(params: {qid: string; id: string}): Promise<void> {
        return this.aviaApi.unsubscribeByDirection({
            qkey: decodeQidOrDefault(params.qid).queryKey,
            id: params.id,
        });
    }

    confirmSubscription(
        params: IConfirmSubscriptionsParams,
    ): Promise<IConfirmSubscriptionAnswer> {
        return this.aviaApi.confirmSubscription({
            id: params.id,
            s: params.s,
            p: params.p,
        });
    }
}
