import {ITravelerDTO} from 'server/api/TravelersApi/types/ITravelerDTO';
import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {
    ITravelerNotebook,
    ITravelerInfo,
} from 'projects/avia/pages/AviaBooking/types/ITravelerNotebook';

export function buildTravelerNotebook(
    traveler: ITravelerDTO,
    passengersWithDocuments: IPassengerWithDocumentsDTO[],
): ITravelerNotebook {
    return {
        travelerInfo: getTravelerInfo(traveler),
        passengersWithDocuments,
    };
}

function getTravelerInfo(traveler: ITravelerDTO): ITravelerInfo {
    return {
        phone: traveler.phone,
        additionalPhone: traveler.phone_additional || null,
        email: traveler.email,
    };
}
