import {EFeatureFlagName, TFeatureFlags} from 'types/IFeatureFlags';

export interface IBunkerFeatureFlag {
    name: EFeatureFlagName;
    enabled: boolean;
    description?: string;
    value?: string;
}

export interface IBunkerFeatureFlagsResponse {
    flags?: IBunkerFeatureFlag[];
}

export const prepareBunkerFeatureFlagsResponse = (
    response: IBunkerFeatureFlagsResponse,
): TFeatureFlags => {
    const flags = response?.flags;

    if (!flags) {
        return {};
    }

    return flags.reduce<TFeatureFlags>((resultFlags, flag) => {
        const {name, enabled, value} = flag;

        return {
            ...resultFlags,
            [name]: {
                enabled,
                value,
            },
        };
    }, {});
};
