import {
    EBusesPopularPriceCurrency,
    IBusesGetPopularDirectionsApiResponse,
} from 'server/api/BusesApi/types/IBusesGetPopularDirectionsApiResponse';
import {
    IBusesGetPopularDirectionsServiceResponse,
    IBusesPopularPrice,
} from 'server/services/BusesService/types/IBusesGetPopularDirectionsServiceResponse';

import {CurrencyType} from 'utilities/currency/CurrencyType';

function transformCurrency(
    currency: EBusesPopularPriceCurrency,
): CurrencyType | null {
    switch (currency) {
        case EBusesPopularPriceCurrency.RUB:
            return CurrencyType.RUB;
        case EBusesPopularPriceCurrency.USD:
            return CurrencyType.USD;
        case EBusesPopularPriceCurrency.EUR:
            return CurrencyType.EUR;
        default:
            return null;
    }
}

export default function getPreparedGetPopularServiceResponse(
    data: IBusesGetPopularDirectionsApiResponse,
): IBusesGetPopularDirectionsServiceResponse {
    const {directions = []} = data;

    return {
        directions: directions.map(direction => {
            const prices = direction.prices.reduce(
                (filteredPrices: IBusesPopularPrice[], price) => {
                    const currency = transformCurrency(price.currency);

                    if (currency && price.amount) {
                        filteredPrices.push({
                            currency,
                            amount: price.amount / 100, // Копейки и так далее, без знаков (переводим в рубли)
                        });
                    }

                    return filteredPrices;
                },
                [],
            );

            const from = {
                id: direction.from.id,
                latitude: direction.from.latitude,
                longitude: direction.from.longitude,
                slug: direction.from.slug,
                title: direction.from.titleDefault,
            };

            const to = {
                id: direction.to.id,
                latitude: direction.to.latitude,
                longitude: direction.to.longitude,
                slug: direction.to.slug,
                title: direction.to.titleDefault,
            };

            return {
                from,
                to,
                prices,
            };
        }),
    };
}
