import moment from 'moment-timezone';

import {IBusesGetSegmentsApiResponse} from 'server/api/BusesApi/types/IBusesGetSegmentsApiResponse';
import {IBusesGetSegmentsServiceResponse} from 'server/services/BusesService/types/IBusesGetSegmentsServiceResponse';

import {ROBOT_DATETIME} from 'utilities/dateUtils/formats';

export default function getPreparedGetSegmentsServiceResponse(
    apiResponse: IBusesGetSegmentsApiResponse,
    fromTimezone: string,
    toTimezone: string,
): IBusesGetSegmentsServiceResponse {
    return {
        segments: apiResponse.data.map(segment => ({
            ...segment,
            price: {
                ...segment.price,
                amount: segment.price.amount / 100,
            },
            departureTime: Number(
                moment.tz(
                    moment
                        .utc(segment.departureTime * 1000)
                        .format(ROBOT_DATETIME),
                    fromTimezone,
                ),
            ),
            arrivalTime:
                segment.arrivalTime &&
                Number(
                    moment.tz(
                        moment
                            .utc(segment.arrivalTime * 1000)
                            .format(ROBOT_DATETIME),
                        toTimezone,
                    ),
                ),
            duration: segment.duration && segment.duration * 1000,
        })),
        isQuerying: apiResponse.status === 202,
    };
}
