import countBy from 'lodash/countBy';

import {IBusesGetSuggestsApiResponse} from 'server/api/BusesGeoApi/types/IBusesGetSuggestsApiResponse';
import {IBusesGetSuggestsServiceResponse} from 'server/services/BusesService/types/IBusesGetSuggestsServiceResponse';
import {EBusesSuggestType} from 'types/buses/common/IBusesSuggest';

export default function getPreparedGetSuggestsServiceResponse(
    response: IBusesGetSuggestsApiResponse,
): IBusesGetSuggestsServiceResponse {
    const {items} = response;

    const pointsHashMap = countBy(items, ({title}) => title);

    return {
        items: items.map(item => ({
            ...item,
            objId:
                (item.objType === EBusesSuggestType.SETTLEMENT ? 'c' : 's') +
                item.objId,
            isUniqueTitle: pointsHashMap[item.title] === 1,
        })),
    };
}
