import {IBusesPopularApiPoint} from 'server/api/BusesApi/types/IBusesGetPopularDirectionsApiResponse';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export interface IBusesPopularPrice {
    currency: CurrencyType;
    amount: number;
}

export interface IBusesPopularPoint
    extends Pick<
        IBusesPopularApiPoint,
        'id' | 'longitude' | 'latitude' | 'slug'
    > {
    title: string;
}

export interface IBusesServicePopularDirection {
    from: IBusesPopularPoint;
    to: IBusesPopularPoint;
    prices: IBusesPopularPrice[];
}

export type TBusesServicePopularDirections = IBusesServicePopularDirection[];

export interface IBusesGetPopularDirectionsServiceResponse {
    directions: TBusesServicePopularDirections;
}
