import IAttributionData from 'server/utilities/DataStorage/AttributionData/types/IAttributionData';
import IUserData from 'server/utilities/DataStorage/UserData/types/IUserData';
import {IAffiliateParams} from 'types/affiliate/IAffiliateParams';
import {IBusesLabelParams} from 'server/api/BusesTravelApi/types/IBusesCreateRideOfferApiParams';

import {GeobaseService} from 'server/services/GeobaseService/GeobaseService';

export default async function getLabelParams({
    attributionData,
    userData,
    affiliateParams,
    wizardReqId,
    ytpReferer,
    userIp,
    geobaseService,
}: {
    attributionData: IAttributionData;
    userData: IUserData;
    affiliateParams: IAffiliateParams;
    wizardReqId: string;
    ytpReferer: string | undefined;
    userIp: string;
    geobaseService: GeobaseService;
}): Promise<IBusesLabelParams> {
    const utm = attributionData.getUtm();

    const {geoId} = await geobaseService.getUserGeoLocation();

    return {
        serpReqId: attributionData.getSerpReqId(),
        utmSource: utm.utmSource,
        utmMedium: utm.utmMedium,
        utmCampaign: utm.utmCampaign,
        utmTerm: utm.utmTerm,
        utmContent: utm.utmContent,
        from: attributionData.getFrom(),
        gclid: attributionData.getGclid(),
        icookie: userData.getICookie(),
        serpUuid: attributionData.getSerpUuid(),
        testBuckets: attributionData.getUaas().testBuckets,
        device: userData.getDeviceType(),
        terminal: 'travel',
        ip: userIp,
        regionId: geoId,
        uid: userData.getPassportId(),
        yandexUid: userData.getYandexUid(),
        wizardReqId,
        serpTestId: attributionData.getSerpTestId(),
        ytpReferer,
        yclid: attributionData.getYclid(),
        fbclid: attributionData.getFbclid(),
        metrikaClientId: userData.getMetrikaClientId(),
        ...affiliateParams,
    };
}
