import {
    ICrossLinksApiParams,
    ICrossLinksApiResponse,
} from 'server/api/CommonApi/types/CrossLinks';
import {IGetUserYandexPlusInfoResponse} from 'server/api/CommonApi/types/YandexPlus';
import {ICommonService} from 'server/services/CommonService/types';

import {IDependencies} from 'server/getContainerConfig';
import {CommonApi} from 'server/api/CommonApi/CommonApi';

export class CommonService implements ICommonService {
    private commonApi: CommonApi;

    constructor({commonApi}: IDependencies) {
        this.commonApi = commonApi;
    }

    getCrossLinks(
        params: ICrossLinksApiParams,
    ): Promise<ICrossLinksApiResponse> {
        return this.commonApi.getCrossLinks(params);
    }

    getUserYandexPlusInfo(): Promise<IGetUserYandexPlusInfoResponse> {
        return this.commonApi.getUserYandexPlusInfo();
    }
}
