import {ITransformSearchContextResponse} from 'server/api/TransformSearchApi/types/ITransformSearchContextResponse';
import {ITransformSearchContextRequestParams} from 'server/api/TransformSearchApi/types/ITransformSearchContextRequestParams';

import {TransformSearchApi} from 'server/api/TransformSearchApi/TransformSearchApi';

import {IDependencies} from '../../getContainerConfig';

export interface ICrossSearchService {
    transformSearchContext(
        params: ITransformSearchContextRequestParams,
    ): Promise<ITransformSearchContextResponse>;
}

export class CrossSearchService implements ICrossSearchService {
    private transformSearchApi: TransformSearchApi;

    constructor({transformSearchApi}: IDependencies) {
        this.transformSearchApi = transformSearchApi;
    }

    async transformSearchContext(
        params: ITransformSearchContextRequestParams,
    ): Promise<ITransformSearchContextResponse> {
        return this.transformSearchApi.transformSearchContext(params);
    }
}
