import IExperimentsService from 'server/services/ExperimentsService/types/IExperimentsService';
import {TUaasExperiments} from '@yandex-data-ui/core/lib/types';

import {IDependencies} from 'server/getContainerConfig';

export class ExperimentsService implements IExperimentsService {
    private readonly uaasExperiments: TUaasExperiments;
    private readonly env: string | undefined;

    constructor({appConfig}: IDependencies) {
        this.uaasExperiments = appConfig.uaasExperiments;
        this.env = appConfig.env;
    }

    async getExperiments(): Promise<TUaasExperiments | null> {
        if (this.env === 'production') {
            return null;
        }

        return this.uaasExperiments;
    }
}
