import {Request} from '@yandex-data-ui/core/lib/types';
import IGenericOrderCreateOrderApiResponse from 'server/api/GenericOrderApi/types/createOrder/IGenericOrderCreateOrderApiResponse';
import IGenericOrderStartPaymentApiParams from 'server/api/GenericOrderApi/types/startPayment/IGenericOrderStartPaymentApiParams';
import IGenericOrderCancelOrderApiParams from 'server/api/GenericOrderApi/types/cancelOrder/IGenericOrderCancelOrderApiParams';
import IGenericOrderGetOrderStateApiParams from 'server/api/GenericOrderApi/types/getOrderState/IGenericOrderGetOrderStateApiParams';
import IGenericOrderGetOrderStateApiResponse from 'server/api/GenericOrderApi/types/getOrderState/IGenericOrderGetOrderStateApiResponse';
import IGenericOrderGetOrderApiParams from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiParams';
import IGenericOrderCalculateRefundAmountApiParams from 'server/api/GenericOrderApi/types/calculateRefundAmount/IGenericOrderCalculateRefundAmountApiParams';
import IGenericOrderCalculateRefundAmountApiResponse from 'server/api/GenericOrderApi/types/calculateRefundAmount/IGenericOrderCalculateRefundAmountApiResponse';
import IGenericOrderStartRefundApiParams from 'server/api/GenericOrderApi/types/startRefund/IGenericOrderStartRefundApiParams';
import IGenericOrderEstimateDiscountApiParams from 'server/api/GenericOrderApi/types/estimateDiscount/IGenericOrderEstimateDiscountApiParams';
import IGenericOrderEstimateDiscountApiResponse from 'server/api/GenericOrderApi/types/estimateDiscount/IGenericOrderEstimateDiscountApiResponse';
import IGenericOrderAddServiceApiParams from 'server/api/GenericOrderApi/types/addService/IGenericOrderAddServiceApiParams';
import IGenericOrderAddServiceApiResponse from 'server/api/GenericOrderApi/types/addService/IGenericOrderAddServiceApiResponse';
import IGenericOrderCreateOrderServiceParams from 'server/services/GenericOrderService/types/createOrder/IGenericOrderCreateOrderServiceParams';
import IGenericOrderGetOrderApiResponse from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiResponse';
import IGenericOrderDownloadBlankApiParams from 'server/api/GenericOrderApi/types/downloadBlank/IGenericOrderDownloadBlankApiParams';

export default interface IGenericOrderService {
    createOrder(
        params: IGenericOrderCreateOrderServiceParams,
        req?: Request,
    ): Promise<IGenericOrderCreateOrderApiResponse>;

    startPayment(params: IGenericOrderStartPaymentApiParams): Promise<void>;

    cancelOrder(params: IGenericOrderCancelOrderApiParams): Promise<void>;

    getOrderState(
        params: IGenericOrderGetOrderStateApiParams,
    ): Promise<IGenericOrderGetOrderStateApiResponse>;

    getOrder(
        params: IGenericOrderGetOrderApiParams,
    ): Promise<IGenericOrderGetOrderApiResponse>;

    calculateRefundAmount(
        params: IGenericOrderCalculateRefundAmountApiParams,
    ): Promise<IGenericOrderCalculateRefundAmountApiResponse>;

    startRefund(params: IGenericOrderStartRefundApiParams): Promise<void>;

    estimateDiscount(
        params: IGenericOrderEstimateDiscountApiParams,
    ): Promise<IGenericOrderEstimateDiscountApiResponse>;

    addService(
        params: IGenericOrderAddServiceApiParams,
    ): Promise<IGenericOrderAddServiceApiResponse>;

    downloadBlank(
        params: IGenericOrderDownloadBlankApiParams,
    ): Promise<NodeJS.ReadableStream>;
}
