import {IHotelsExtranetOrdersRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersRequest';
import {IHotelsExtranetOrdersResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetOrdersResponse';
import {IHotelsExtranetPaymentsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsRequest';
import {IHotelsExtranetPaymentsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentsResponse';
import {IHotelsExtranetAddHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelRequest';
import {IHotelsExtranetAddHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetAddHotelResponse';
import {IHotelsExtranetApproveHotelResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelResponse';
import {IHotelsExtranetApproveHotelRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetApproveHotelRequest';
import {IHotelsListResponse} from 'server/api/HotelsExtranetApi/types/IHotelsListResponse';
import {IHotelsExtranetPaymentDetailsRequest} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsRequest';
import {IHotelsExtranetPaymentDetailsResponse} from 'server/api/HotelsExtranetApi/types/IHotelsExtranetPaymentDetailsResponse';

import {HotelsExtranetApi} from 'server/api/HotelsExtranetApi/HotelsExtranetApi';
import {IDependencies} from 'server/getContainerConfig';

export interface IHotelsExtranetService {
    addHotel(
        request: IHotelsExtranetAddHotelRequest,
    ): Promise<IHotelsExtranetAddHotelResponse>;

    approveHotel(
        request: IHotelsExtranetApproveHotelRequest,
    ): Promise<IHotelsExtranetApproveHotelResponse>;

    getHotels(): Promise<IHotelsListResponse>;

    getOrders(
        request: IHotelsExtranetOrdersRequest,
    ): Promise<IHotelsExtranetOrdersResponse>;

    getPayments(
        request: IHotelsExtranetPaymentsRequest,
    ): Promise<IHotelsExtranetPaymentsResponse>;

    getPaymentDetails(
        params: IHotelsExtranetPaymentDetailsRequest,
    ): Promise<IHotelsExtranetPaymentDetailsResponse>;
}

export class HotelsExtranetService implements IHotelsExtranetService {
    private hotelsExtranetApi: HotelsExtranetApi;

    constructor({hotelsExtranetApi}: IDependencies) {
        this.hotelsExtranetApi = hotelsExtranetApi;
    }

    addHotel(
        request: IHotelsExtranetAddHotelRequest,
    ): Promise<IHotelsExtranetAddHotelResponse> {
        return this.hotelsExtranetApi.addHotel(request);
    }

    approveHotel(
        request: IHotelsExtranetApproveHotelRequest,
    ): Promise<IHotelsExtranetApproveHotelResponse> {
        return this.hotelsExtranetApi.approveHotel(request);
    }

    getHotels(): Promise<IHotelsListResponse> {
        return this.hotelsExtranetApi.getHotels();
    }

    getOrders(
        request: IHotelsExtranetOrdersRequest,
    ): Promise<IHotelsExtranetOrdersResponse> {
        return this.hotelsExtranetApi.getOrders(request);
    }

    getPayments(
        request: IHotelsExtranetPaymentsRequest,
    ): Promise<IHotelsExtranetPaymentsResponse> {
        return this.hotelsExtranetApi.getPayments(request);
    }

    getPaymentDetails(
        params: IHotelsExtranetPaymentDetailsRequest,
    ): Promise<IHotelsExtranetPaymentDetailsResponse> {
        return this.hotelsExtranetApi.getPaymentDetails(params);
    }
}
