import IGetCrossSaleHotelsRequestParamsV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV1';
import IGetCrossSaleHotelsResponseV1 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV1';
import IGetCrossSaleHotelsRequestParamsV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsRequestParamsV3';
import IGetCrossSaleHotelsResponseV3 from 'server/api/HotelsCrossSaleApi/types/IGetCrossSaleHotelsResponseV3';

import {HotelsCrossSaleApi} from 'server/api/HotelsCrossSaleApi/HotelsCrossSaleApi';

import {IDependencies} from '../../getContainerConfig';

export type TGetCrossSaleHotelsV1Type = (
    params: IGetCrossSaleHotelsRequestParamsV1,
) => Promise<IGetCrossSaleHotelsResponseV1>;

export type TGetCrossSaleHotelsV3Type = (
    params: IGetCrossSaleHotelsRequestParamsV3,
) => Promise<IGetCrossSaleHotelsResponseV3>;

export interface IHotelsCrossSaleService {
    getCrossSaleHotelsV1: TGetCrossSaleHotelsV1Type;
    getCrossSaleHotelsV3: TGetCrossSaleHotelsV3Type;
}

export class HotelsCrossSaleService implements IHotelsCrossSaleService {
    private hotelsCrossSaleApi: HotelsCrossSaleApi;

    constructor({hotelsCrossSaleAPI}: IDependencies) {
        this.hotelsCrossSaleApi = hotelsCrossSaleAPI;
    }

    async getCrossSaleHotelsV1(
        params: IGetCrossSaleHotelsRequestParamsV1,
    ): Promise<IGetCrossSaleHotelsResponseV1> {
        return this.hotelsCrossSaleApi.getCrossSaleHotelsV1(params);
    }

    async getCrossSaleHotelsV3(
        params: IGetCrossSaleHotelsRequestParamsV3,
    ): Promise<IGetCrossSaleHotelsResponseV3> {
        return this.hotelsCrossSaleApi.getCrossSaleHotelsV3(params);
    }
}
