import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';
import {TAddFavoriteHotelResponse} from 'server/api/HotelsFavoritesAPI/types/TAddFavoriteHotelResponse';
import {TRemoveFavoriteHotelsRequestParams} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';
import IRemoveFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsResponse';
import IGetFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsResponse';
import IGetFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsRequestParams';
import IGetFavoriteHotelsOffersResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsOffersResponse';
import IGetFavoriteHotelsOffersRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsOffersRequestParams';
import IShareFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IShareFavoriteHotelsRequestParams';
import IShareFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IShareFavoriteHotelsResponse';
import IGetSharedFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsRequestParams';
import IGetSharedFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsResponse';

import {HotelsFavoritesAPI} from 'server/api/HotelsFavoritesAPI/HotelsFavoritesAPI';

import {IDependencies} from '../../getContainerConfig';

export type TAddFavoriteHotelType = (
    params: IAddFavoriteHotelRequestParams,
) => Promise<TAddFavoriteHotelResponse>;

export type TRemoveFavoriteHotelsType = (
    params: TRemoveFavoriteHotelsRequestParams,
) => Promise<IRemoveFavoriteHotelsResponse>;

export type TGetFavoriteHotelsType = (
    params: IGetFavoriteHotelsRequestParams,
) => Promise<IGetFavoriteHotelsResponse>;

export type TGetFavoriteHotelsOffersType = (
    params: IGetFavoriteHotelsOffersRequestParams,
) => Promise<IGetFavoriteHotelsOffersResponse>;

export type TShareFavoriteHotelsType = (
    params: IShareFavoriteHotelsRequestParams,
) => Promise<IShareFavoriteHotelsResponse>;

export type TGetSharedFavoriteHotelsType = (
    params: IGetSharedFavoriteHotelsRequestParams,
) => Promise<IGetSharedFavoriteHotelsResponse>;

export interface IHotelsFavoritesService {
    addFavoriteHotel: TAddFavoriteHotelType;
    removeFavoriteHotels: TRemoveFavoriteHotelsType;
    getFavoriteHotels: TGetFavoriteHotelsType;
    getFavoriteHotelsOffers: TGetFavoriteHotelsOffersType;
    shareFavoriteHotels: TShareFavoriteHotelsType;
    getSharedFavoriteHotels: TGetSharedFavoriteHotelsType;
}

export class HotelsFavoritesService implements IHotelsFavoritesService {
    private hotelsFavoritesAPI: HotelsFavoritesAPI;

    constructor({hotelsFavoritesAPI}: IDependencies) {
        this.hotelsFavoritesAPI = hotelsFavoritesAPI;
    }

    async addFavoriteHotel(
        params: IAddFavoriteHotelRequestParams,
    ): Promise<TAddFavoriteHotelResponse> {
        return this.hotelsFavoritesAPI.addFavoriteHotel(params);
    }

    async removeFavoriteHotels(
        params: TRemoveFavoriteHotelsRequestParams,
    ): Promise<IRemoveFavoriteHotelsResponse> {
        return this.hotelsFavoritesAPI.removeFavoriteHotels(params);
    }

    async getFavoriteHotels(
        params: IGetFavoriteHotelsRequestParams,
    ): Promise<IGetFavoriteHotelsResponse> {
        return this.hotelsFavoritesAPI.getFavoriteHotels(params);
    }

    async getFavoriteHotelsOffers(
        params: IGetFavoriteHotelsOffersRequestParams,
    ): Promise<IGetFavoriteHotelsOffersResponse> {
        return this.hotelsFavoritesAPI.getFavoriteHotelsOffers(params);
    }

    async shareFavoriteHotels(
        params: IShareFavoriteHotelsRequestParams,
    ): Promise<IShareFavoriteHotelsResponse> {
        return this.hotelsFavoritesAPI.shareFavoriteHotels(params);
    }

    async getSharedFavoriteHotels(
        params: IGetSharedFavoriteHotelsRequestParams,
    ): Promise<IGetSharedFavoriteHotelsResponse> {
        return this.hotelsFavoritesAPI.getSharedFavoriteHotels(params);
    }
}
