import {IApplyPromoCodesRequest} from 'types/hotels/book/IApplyPromoCodes';
import {IEstimateDiscountRequestParams} from 'server/api/HotelsBookAPI/types/IEstimateDiscount';

export function prepareEstimateDiscountRequest(
    request: IApplyPromoCodesRequest,
): IEstimateDiscountRequestParams {
    const {
        bookUserSelect: {bedsGroupId},
        offerOrderInfo: {label, checksum, sessionKey, token},
        promoCodes,
        appliedPromoCampaigns,
        customerUserAgent = '',
        customerPassportId = '',
        customerYandexUid = '',
        customerIp,
        customerLogin,
    } = request;

    return {
        label,
        token,
        checksum,
        selectedBedGroupIndex: parseInt(bedsGroupId, 10),
        sessionKey,
        customerIp: typeof customerIp === 'string' ? customerIp : '',
        customerUserAgent,
        customerPassportId,
        customerYandexUid,
        customerLogin: customerLogin || '',
        promoCodes,
        appliedPromoCampaigns,
    };
}
