import ILevelTravelService from 'server/services/LevelTravelService/types/ILevelTravelService';
import {
    IAutocompleteParams,
    IGetAvailableCountriesParams,
    IGetCountriesParams,
    IGetCountriesResponse,
    IGetDeparturesParams,
    IGetDeparturesResponse,
    IGetFlightsAndNightsParams,
    IGetFlightsAndNightsResponse,
    IGetRedirectParams,
    IGetRedirectResponse,
    TAutocompleteResponse,
    TGetAvailableCountriesResponse,
} from 'server/api/LevelTravelApi/types';

import {IDependencies} from 'server/getContainerConfig';
import {LevelTravelApi} from 'server/api/LevelTravelApi/LevelTravelApi';

export class LevelTravelService implements ILevelTravelService {
    levelTravelApi: LevelTravelApi;

    constructor({levelTravelApi}: IDependencies) {
        this.levelTravelApi = levelTravelApi;
    }

    async getAvailableCountries(
        query: IGetAvailableCountriesParams,
    ): Promise<TGetAvailableCountriesResponse> {
        return this.levelTravelApi.getAvailableCountries(query);
    }

    async getCountries(
        query: IGetCountriesParams,
    ): Promise<IGetCountriesResponse> {
        return this.levelTravelApi.getCountries(query);
    }

    async autocomplete(
        query: IAutocompleteParams,
    ): Promise<TAutocompleteResponse> {
        return this.levelTravelApi.autocomplete(query);
    }

    async getDepartures(
        query: IGetDeparturesParams,
    ): Promise<IGetDeparturesResponse> {
        return this.levelTravelApi.getDepartures(query);
    }

    async getRedirect(
        query: IGetRedirectParams,
    ): Promise<IGetRedirectResponse> {
        return this.levelTravelApi.getRedirect(query);
    }

    async getFlightsAndNights(
        query: IGetFlightsAndNightsParams,
    ): Promise<IGetFlightsAndNightsResponse> {
        return this.levelTravelApi.getFlightsAndNights(query);
    }
}
