import {
    IAutocompleteParams,
    IGetAvailableCountriesParams,
    IGetCountriesParams,
    IGetCountriesResponse,
    IGetDeparturesParams,
    IGetDeparturesResponse,
    IGetFlightsAndNightsParams,
    IGetFlightsAndNightsResponse,
    IGetRedirectParams,
    IGetRedirectResponse,
    TAutocompleteResponse,
    TGetAvailableCountriesResponse,
} from 'server/api/LevelTravelApi/types';

export default interface ILevelTravelService {
    getAvailableCountries(
        query: IGetAvailableCountriesParams,
    ): Promise<TGetAvailableCountriesResponse>;
    getCountries(query: IGetCountriesParams): Promise<IGetCountriesResponse>;
    getDepartures(query: IGetDeparturesParams): Promise<IGetDeparturesResponse>;
    getRedirect(query: IGetRedirectParams): Promise<IGetRedirectResponse>;
    getFlightsAndNights(
        query: IGetFlightsAndNightsParams,
    ): Promise<IGetFlightsAndNightsResponse>;
    autocomplete(query: IAutocompleteParams): Promise<TAutocompleteResponse>;
}
