import {INotebookPassenger} from 'server/api/NotebookApi/types/models';
import {INotebookSavePassengerParams} from 'server/services/NotebookService/types/INotebookSaveTravelerAndPassengersService';
import {INotebookCreatePassengerService} from 'server/services/NotebookService/types/INotebookCreatePassengerService';

export default async function findOrCreatePassenger({
    existedPassengers,
    passenger,
    createPassenger,
}: {
    existedPassengers: INotebookPassenger[];
    passenger: INotebookSavePassengerParams;
    createPassenger: INotebookCreatePassengerService;
}): Promise<INotebookPassenger> {
    const existedPassenger = existedPassengers.find(localExistedPassenger => {
        const hasSamePassengerInfo =
            localExistedPassenger.gender === passenger.gender &&
            localExistedPassenger.birthDate === passenger.birthDate;

        const hasSameFIODocument =
            !localExistedPassenger.documents ||
            localExistedPassenger.documents.some(document => {
                return (
                    (document.firstName === passenger.document.firstName &&
                        document.lastName === passenger.document.lastName &&
                        document.middleName ===
                            passenger.document.middleName) ||
                    (document.firstNameEn === passenger.document.firstNameEn &&
                        document.lastNameEn === passenger.document.lastNameEn &&
                        document.middleNameEn ===
                            passenger.document.middleNameEn)
                );
            });

        return hasSamePassengerInfo && hasSameFIODocument;
    });

    if (existedPassenger) {
        return existedPassenger;
    }

    return createPassenger({
        passenger,
    });
}
