import {
    INotebookBonusCard,
    INotebookPassenger,
} from 'server/api/NotebookApi/types/models';
import {INotebookCreatePassengerBonusCardParams} from 'server/api/NotebookApi/types/createPassengerBonusCard';
import {INotebookCreatePassengerBonusCardService} from 'server/services/NotebookService/types/INotebookCreatePassengerBonusCardService';

export default async function findOrCreatePassengerBonusCard({
    existedPassenger,
    bonusCard,
    createBonusCard,
}: {
    existedPassenger: INotebookPassenger;
    bonusCard: INotebookCreatePassengerBonusCardParams;
    createBonusCard: INotebookCreatePassengerBonusCardService;
}): Promise<INotebookBonusCard> {
    const existedBonusCard = existedPassenger.bonusCards?.find(
        localBonusCard =>
            localBonusCard.type === bonusCard.type &&
            localBonusCard.number === bonusCard.number,
    );

    if (existedBonusCard) {
        return existedBonusCard;
    }

    return createBonusCard({
        passengerId: existedPassenger.id,
        bonusCard,
    });
}
