import {
    INotebookDocument,
    INotebookPassenger,
} from 'server/api/NotebookApi/types/models';
import {INotebookCreatePassengerDocumentParams} from 'server/api/NotebookApi/types/createPassengerDocument';
import {INotebookCreatePassengerDocumentService} from 'server/services/NotebookService/types/INotebookCreatePassengerDocumentService';

export default async function findOrCreatePassengerDocument({
    existedPassenger,
    document,
    createDocument,
}: {
    existedPassenger: INotebookPassenger;
    document: INotebookCreatePassengerDocumentParams;
    createDocument: INotebookCreatePassengerDocumentService;
}): Promise<INotebookDocument> {
    const existedDocument = existedPassenger.documents?.find(
        localDocument =>
            localDocument.type === document.type &&
            localDocument.number === document.number &&
            localDocument.citizenship === document.citizenship,
    );

    if (existedDocument) {
        return existedDocument;
    }

    return createDocument({
        passengerId: existedPassenger.id,
        document,
    });
}
