import {IGetOrderHappyPageServiceParams} from 'server/services/OrdersService/types/IGetOrderHappyPageServiceParams';
import {IOrdersIOrdersGetUserPromoAttributesApiResponse} from 'server/api/OrdersAPI/types/IOrdersIOrdersGetUserPromoAttributesApiResponse';
import {
    ICreateOrderAuthorizationResponse,
    TCreateOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICreateOrderAuthorization';
import {TGetOrderHappyPageServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';
import {IOrdersService} from 'server/services/OrdersService/types/IOrdersService';
import {TGetPaymentTestContextTokenParams} from 'server/api/OrdersAPI/types/TGetPaymentTestContextTokenParams';
import IGetPaymentTestContextTokenResponse from 'server/api/OrdersAPI/types/IGetPaymentTestContextTokenResponse';
import {
    ICheckOrderAuthorizationResponse,
    TCheckOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICheckOrderAuthorization';

import {IDependencies} from 'server/getContainerConfig';
import {OrdersAPI} from 'server/api/OrdersAPI/OrdersAPI';
import {GeobaseService} from 'server/services/GeobaseService/GeobaseService';
import prepareGetOrderHappyPageServiceResponse from 'server/services/OrdersService/dataTransformers/prepareGetOrderHappyPageServiceResponse';
import {TestContextService} from 'server/services/TestContextService/TestContextService';

export class OrdersService implements IOrdersService {
    private ordersAPI: OrdersAPI;
    private geoBaseService: GeobaseService;
    private testContextService: TestContextService;

    constructor({
        ordersAPI,
        geobaseService,
        testContextService,
    }: IDependencies) {
        this.ordersAPI = ordersAPI;
        this.geoBaseService = geobaseService;
        this.testContextService = testContextService;
    }

    /* Fetch orders flow */

    async getOrderHappyPage(
        params: IGetOrderHappyPageServiceParams,
    ): Promise<TGetOrderHappyPageServiceResponse> {
        const geoId = await this.geoBaseService.getRegionId();
        const apiResponse = await this.ordersAPI.getOrderHappyPage({
            ...params,
            geoId,
        });

        return prepareGetOrderHappyPageServiceResponse(apiResponse);
    }

    getUserPromoAttributes(): Promise<IOrdersIOrdersGetUserPromoAttributesApiResponse> {
        return this.ordersAPI.getUserPromoAttributes();
    }

    /* Authorization order flow */

    async checkOrderAuthorization(
        params: TCheckOrderAuthorizationRequestParams,
    ): Promise<ICheckOrderAuthorizationResponse> {
        return this.ordersAPI.checkOrderAuthorization(params);
    }

    async createOrderAuthorization(
        params: TCreateOrderAuthorizationRequestParams,
    ): Promise<ICreateOrderAuthorizationResponse> {
        return this.ordersAPI.createOrderAuthorization(params);
    }

    async getPaymentTestContextToken(
        params: TGetPaymentTestContextTokenParams,
    ): Promise<IGetPaymentTestContextTokenResponse> {
        return this.testContextService.getPaymentTestContextToken(params);
    }
}
