import {IAirOrderReservation, IAviaOrder} from 'types/avia/book/IAviaOrder';
import {IAviaOrderResponse} from 'server/api/OrdersAPI/types/IAviaOrderResponse';

import {flightDTOtoFlightModel} from 'server/utilities/lib/avia/booking/flightDTOtoFlightModel';

export const prepareAviaOrderAirReservation = (
    orderResponse: IAviaOrderResponse,
): IAirOrderReservation => {
    const {
        airReservation: {pnr, segments},
        reference,
    } = orderResponse;

    return {
        pnr,
        segments: segments.map(({flights}) => ({
            flights: flights.map(segmentFlight =>
                flightDTOtoFlightModel(segmentFlight, reference),
            ),
        })),
    };
};

export const prepareAviaOrderResponse = (
    orderResponse: IAviaOrderResponse,
): IAviaOrder => {
    const {
        id,
        prettyId,
        email,
        phone,
        edisplayOrderState,
        promoCampaigns,
        errorCode,
    } = orderResponse;

    return {
        id,
        displayState: edisplayOrderState,
        prettyId,
        email,
        phone,
        airReservation: prepareAviaOrderAirReservation(orderResponse),
        promoCampaigns,
        errorCode,
    };
};
