import {TOrdersGetOrderHappyPageApiResponse} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';
import {TGetOrderHappyPageServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';

import {prepareOrderResponse} from 'server/api/HotelsBookAPI/utilities/prepareOrder';

import prepareTrainOrderResponse from 'server/services/TrainsService/prepareData/prepareOrderResponse';
import {
    prepareTrainsHpGenericOrderResponse,
    checkTrainsHpGenericOrderByOrderResponse,
} from 'server/services/TrainsService/prepareData/prepareTrainsHpGenericOrderResponse';

import {prepareAviaOrderResponse} from './prepareAviaOrderResponse';

export default function prepareGetOrderHappyPageServiceResponse(
    happyPageApiResponse: TOrdersGetOrderHappyPageApiResponse,
): TGetOrderHappyPageServiceResponse {
    switch (happyPageApiResponse.orderType) {
        case EOrderApiType.HOTEL: {
            return {
                ...happyPageApiResponse,
                order: prepareOrderResponse(happyPageApiResponse.order),
            };
        }

        case EOrderApiType.TRAIN: {
            const trainsOriginalOrder = happyPageApiResponse.order;
            const isTrainsHpGenericOrder =
                checkTrainsHpGenericOrderByOrderResponse(trainsOriginalOrder);

            return {
                ...happyPageApiResponse,
                order: isTrainsHpGenericOrder
                    ? prepareTrainsHpGenericOrderResponse(trainsOriginalOrder)
                    : prepareTrainOrderResponse(trainsOriginalOrder),
            };
        }

        case EOrderApiType.AVIA: {
            return {
                ...happyPageApiResponse,
                order: prepareAviaOrderResponse(happyPageApiResponse.order),
            };
        }

        case EOrderApiType.BUS: {
            return happyPageApiResponse;
        }
    }
}
