import {IGetOrderHappyPageServiceParams} from 'server/services/OrdersService/types/IGetOrderHappyPageServiceParams';
import {TGetOrderHappyPageServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';
import {IOrdersIOrdersGetUserPromoAttributesApiResponse} from 'server/api/OrdersAPI/types/IOrdersIOrdersGetUserPromoAttributesApiResponse';
import {
    ICreateOrderAuthorizationResponse,
    TCreateOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICreateOrderAuthorization';
import {TGetPaymentTestContextTokenParams} from 'server/api/OrdersAPI/types/TGetPaymentTestContextTokenParams';
import IGetPaymentTestContextTokenResponse from 'server/api/OrdersAPI/types/IGetPaymentTestContextTokenResponse';
import {
    ICheckOrderAuthorizationResponse,
    TCheckOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICheckOrderAuthorization';

export interface IOrdersService {
    getOrderHappyPage(
        params: IGetOrderHappyPageServiceParams,
    ): Promise<TGetOrderHappyPageServiceResponse>;

    getUserPromoAttributes(): Promise<IOrdersIOrdersGetUserPromoAttributesApiResponse>;

    checkOrderAuthorization(
        params: TCheckOrderAuthorizationRequestParams,
    ): Promise<ICheckOrderAuthorizationResponse>;

    createOrderAuthorization(
        params: TCreateOrderAuthorizationRequestParams,
    ): Promise<ICreateOrderAuthorizationResponse>;

    getPaymentTestContextToken(
        params: TGetPaymentTestContextTokenParams,
    ): Promise<IGetPaymentTestContextTokenResponse>;
}
