import {Overwrite} from 'utility-types';

import {
    IHappyPageAviaApiResponse,
    IHappyPageBusApiResponse,
    IHappyPageHotelApiResponse,
    IHappyPageTrainApiResponse,
} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';
import {
    ITrainsHpGenericOrder,
    ITrainsOrderDetails,
} from 'reducers/trains/order/types';
import {IOrder} from 'server/api/HotelsBookAPI/types/IOrder';
import {IAviaOrder} from 'types/avia/book/IAviaOrder';

export interface IHappyPageTrainServiceResponse
    extends Overwrite<
        IHappyPageTrainApiResponse,
        {
            order: ITrainsOrderDetails | ITrainsHpGenericOrder;
        }
    > {}

export interface IHappyPageHotelServiceResponse
    extends Overwrite<
        IHappyPageHotelApiResponse,
        {
            order: IOrder;
        }
    > {}

export interface IHappyPageAviaServiceResponse
    extends Overwrite<
        IHappyPageAviaApiResponse,
        {
            order: IAviaOrder;
        }
    > {}

export type TGetOrderHappyPageServiceResponse =
    | IHappyPageTrainServiceResponse
    | IHappyPageHotelServiceResponse
    | IHappyPageAviaServiceResponse
    | IHappyPageBusApiResponse;
