import IGetHotelsSuggestsResponse from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsResponse';
import IGetAviaSearchHistoryResponse from 'server/api/PersonalizationApi/types/IGetAviaSearchHistoryResponse';
import IGetHotelsSuggestsRequestParams from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsRequestParams';
import IGetAviaSearchHistoryRequestParams from 'server/api/PersonalizationApi/types/IGetAviaSearchHistoryRequestParams';

import {PersonalizationApi} from 'server/api/PersonalizationApi/PersonalizationApi';

import {IDependencies} from '../../getContainerConfig';

export type TGetHotelsSuggestsServiceType = (
    params: IGetHotelsSuggestsRequestParams,
) => Promise<IGetHotelsSuggestsResponse>;

export type TGetAviaSearchHistoryServiceType = (
    params: IGetAviaSearchHistoryServiceParams,
) => Promise<IGetAviaSearchHistoryResponse>;

export interface IGetAviaSearchHistoryServiceParams
    extends Omit<IGetAviaSearchHistoryRequestParams, 'yandexuid'> {}

export interface IPersonalizationService {
    getHotelsSuggests: TGetHotelsSuggestsServiceType;
    getAviaSearchHistory: TGetAviaSearchHistoryServiceType;
}

export class PersonalizationService implements IPersonalizationService {
    private personalizationApi: PersonalizationApi;
    private yandexuid: string;

    constructor({personalizationApi, yandexuid}: IDependencies) {
        this.personalizationApi = personalizationApi;
        this.yandexuid = yandexuid;
    }

    async getHotelsSuggests(
        params: IGetHotelsSuggestsRequestParams,
    ): Promise<IGetHotelsSuggestsResponse> {
        return this.personalizationApi.getHotelsSuggests(params);
    }

    async getAviaSearchHistory(
        params: IGetAviaSearchHistoryServiceParams,
    ): Promise<IGetAviaSearchHistoryResponse> {
        return this.personalizationApi.getAviaSearchHistory({
            ...params,
            yandexuid: this.yandexuid,
        });
    }
}
