import {LANG} from 'constants/langCodes';

import {IRaspGetTrainOrderSegmentApiParams} from 'server/api/RaspApi/types/IRaspGetTrainOrderSegmentApi/IRaspGetTrainOrderSegmentApi';
import {IRaspGetTrainOrderSegmentServiceParams} from 'server/services/RaspService/types/IRaspGetTrainOrderSegmentService';

export default function prepareRaspGetTrainOrderSegmentApiParams(
    params: IRaspGetTrainOrderSegmentServiceParams,
): IRaspGetTrainOrderSegmentApiParams {
    const {departure, language = LANG.RU} = params;

    const [date, time] = departure.split('T');

    return {
        ...params,
        language,
        departure: `${date}T${time.replace('.', ':')}`,
    };
}
