import {ISimpleTextReview} from 'types/common/ISimpleTextReview';
import {IFormattedTrainsReviews} from 'server/services/ReviewsService/types/IFormattedTrainsReviews';
import {IReviewsGetTrainsReviewsApiResponse} from 'server/api/ReviewsApi/types/IReviewsGetTrainsReviewsApiResponse';

export function formatTrainReviews({
    reviews,
    directions,
}: IReviewsGetTrainsReviewsApiResponse): IFormattedTrainsReviews {
    return {
        reviews: reviews.reduce<Record<number, ISimpleTextReview>>(
            (res, item) => {
                res[item.id] = {
                    text: item.text,
                    rating: parseInt(item.rating, 10),
                    title: `Поезд ${item.trainNumber}`,
                    updatedAt: item.updatedAt,
                };

                return res;
            },
            {},
        ),
        directions: directions.reduce<Record<string, number[]>>(
            (res, [slugFrom, slugTo, ids]) => {
                res[`${slugFrom}--${slugTo}`] = ids;

                return res;
            },
            {},
        ),
    };
}
