import {sortBy} from 'lodash';

import {ISimpleTextReview} from 'types/common/ISimpleTextReview';
import {IFormattedTrainsReviews} from 'server/services/ReviewsService/types/IFormattedTrainsReviews';

export function getRecentReviews(
    {directions, reviews}: IFormattedTrainsReviews,
    direction: string,
    count: number = 4,
): ISimpleTextReview[] {
    const directionReviewIds = directions[direction];

    if (!directionReviewIds) {
        return [];
    }

    return sortBy(
        directionReviewIds.reduce<ISimpleTextReview[]>((res, id) => {
            if (reviews[id]) {
                res.push(reviews[id]);
            }

            return res;
        }, []),
        ['updatedAt'],
    )
        .slice(-count)
        .reverse();
}
