import {IDocumentMutationDTO} from 'server/api/TravelersApi/types/IDocumentDTO';

import {RUS_NAME} from 'projects/trains/lib/order/fields/masks';

import {IPreparedStoreDocument} from './prepareDocumentToStore';

/*
 * Функция возвращает информацию, нужную для создания документа пассажира по документу из заказа.
 */
export default function getDataToCreateTravelerDocument(
    orderPassengerDocument: IPreparedStoreDocument,
): IDocumentMutationDTO {
    const {
        title,
        type,
        number,
        citizenship,
        firstName,
        lastName,
        middleName,
        validDate,
    } = orderPassengerDocument;

    const data: IDocumentMutationDTO = {
        title,
        type,
        number,
        citizenship,
        expiration_date: validDate,
    };

    const rusNameRegExp = new RegExp(`^${RUS_NAME}$`);

    // Так как у нас нельзя вводить ФИО на разных языках,
    // то можно сделать проверку только одного поля
    if (rusNameRegExp.test(firstName)) {
        data.first_name = firstName;
        data.last_name = lastName;

        if (middleName) {
            data.middle_name = middleName;
        }
    } else {
        data.first_name_en = firstName;
        data.last_name_en = lastName;

        if (middleName) {
            data.middle_name_en = middleName;
        }
    }

    return data;
}
