/*
 * Функция идентифицирует пассажира по документу
 */
function isPassengerIdentifiedByDocument(
    travelerPassenger,
    orderDocumentToFind,
) {
    return (
        travelerPassenger.documents &&
        travelerPassenger.documents.some(
            document =>
                (document.first_name === orderDocumentToFind.firstName &&
                    document.last_name === orderDocumentToFind.lastName &&
                    ((!document.middle_name &&
                        !orderDocumentToFind.middleName) ||
                        document.middle_name ===
                            orderDocumentToFind.middleName)) ||
                (document.first_name_en === orderDocumentToFind.firstName &&
                    document.last_name_en === orderDocumentToFind.lastName &&
                    ((!document.middle_name_en &&
                        !orderDocumentToFind.middleName) ||
                        document.middle_name_en ===
                            orderDocumentToFind.middleName)),
        )
    );
}

/*
 * Функция в списке пассажировов путешественника ищет пассажира из заказа.
 */
export default function getExistedPassenger(
    travelerPassengers,
    orderPassengerToFind,
) {
    return travelerPassengers.find(
        passenger =>
            passenger.gender === orderPassengerToFind.gender &&
            passenger.birth_date === orderPassengerToFind.birthDate &&
            isPassengerIdentifiedByDocument(
                passenger,
                orderPassengerToFind.document,
            ),
    );
}
